/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.integration;

import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import net.minecraft.server.level.ServerPlayer;

public class FTBRanksIntegration {
    private static final String MAX_BLOCKS_PERM = "ftbultimine.max_blocks";
    private static final String COOLDOWN_PERM = "ftbultimine.ultimine_cooldown";

    public static void init() {
        RankEvent.ADD_PLAYER.register(FTBRanksIntegration::updatePlayer);
        RankEvent.REMOVE_PLAYER.register(FTBRanksIntegration::updatePlayer);
        RankEvent.PERMISSION_CHANGED.register(FTBRanksIntegration::updateAllPlayers);
        RankEvent.RELOADED.register(FTBRanksIntegration::updateAllPlayers);
        RankEvent.CONDITION_CHANGED.register(FTBRanksIntegration::updateAllPlayers);
        FTBUltimine.LOGGER.info("FTB Ranks detected, listening for ranks events");
    }

    public static int getMaxBlocks(ServerPlayer player) {
        return FTBRanksAPI.getPermissionValue((ServerPlayer)player, (String)MAX_BLOCKS_PERM).asInteger().orElse((Integer)FTBUltimineServerConfig.MAX_BLOCKS.get());
    }

    private static void updatePlayer(RankEvent.Player event) {
        ServerPlayer sp = event.getManager().getServer().m_6846_().m_11259_(event.getPlayer().getId());
        if (sp != null) {
            new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(sp), SyncUltimineTimePacket.TimeType.COOLDOWN).sendTo(sp);
        }
    }

    private static void updateAllPlayers(RankEvent event) {
        event.getManager().getServer().m_6846_().m_11314_().forEach(sp -> new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(sp), SyncUltimineTimePacket.TimeType.COOLDOWN).sendTo((ServerPlayer)sp));
    }

    public static long getUltimineCooldown(ServerPlayer player) {
        return FTBRanksAPI.getPermissionValue((ServerPlayer)player, (String)COOLDOWN_PERM).asLong().orElse((Long)FTBUltimineServerConfig.ULTIMINE_COOLDOWN.get());
    }
}

